깃 클론(`git clone`)을 하면 서버 저장소가 그대로 복제되어 로컬에 **작업 가능한 레포지토리 폴더**가 생깁니다. 구조는 다음과 같습니다:

```
project-name/          ← 클론된 프로젝트 루트 디렉터리
├─ .git/               ← 깃 내부 데이터 저장소 (원격과 동기화, 브랜치, 커밋 내역 등)
├─ README.md           ← 서버 저장소에 있던 일반 파일들
├─ src/                ← 서버 저장소에 있던 소스 코드 디렉터리
├─ package.json        ← 예시: Node.js 프로젝트라면 포함될 수 있는 파일
└─ ...                 ← 서버 저장소에 있던 나머지 파일들
```

핵심 포인트:

* **`.git/` 폴더**: 모든 커밋 히스토리, 브랜치 정보, 원격 연결 정보가 들어 있음. (실제 레포지토리 핵심)
* **나머지 파일들**: 서버에 올라간 최신 스냅샷(HEAD 브랜치의 워킹 디렉터리)이 그대로 복제됨.
* 따라서 로컬에는 **(1) 깃 관리용 숨김 폴더 + (2) 실제 작업 파일들** 두 층이 공존.

정리하면, `git clone` → 내 로컬에 **하나의 프로젝트 폴더**가 생기고, 그 안에 `.git`과 서버 저장소의 파일들이 들어오는 구조입니다.

---


로컬에서 `git clone` 한 시점 이후 소스와 메타데이터는 모두 **클론된 레포지토리 폴더 안**에만 존재합니다.
깃은 별도의 전역 디렉터리에 소스 사본을 두지 않습니다. 구조를 나눠보면:

1. **작업 파일(Working Directory)**

   * 레포지토리 루트 아래 일반 파일들 (`src/`, `README.md`, 등).
   * 사용자가 수정·빌드·실행하는 실제 코드.

2. **깃 데이터베이스(.git/ 디렉터리)**

   * 커밋 객체, 블롭(blob), 트리(tree), 태그, 브랜치, 원격 정보.
   * 깃의 "메타데이터" 전부가 여기에 들어 있음.
   * `.git/objects/` 에는 실제 소스 파일 내용(스냅샷)이 압축 저장됨.
   * `.git/refs/` 는 브랜치/태그 포인터.
   * `.git/config` 는 원격 URL, 사용자 환경 설정.

3. **글로벌 설정(필요할 때만)**

   * 사용자 홈 디렉터리(`~/.gitconfig`) → 사용자명/이메일/에디터 같은 글로벌 환경설정.
   * 하지만 여기에는 **개별 레포지토리의 소스나 커밋 히스토리**는 전혀 들어가지 않음.

즉, 깃은 SVN처럼 **별도의 중앙 작업공간이나 숨은 캐시폴더를 두지 않습니다.**
로컬에 생기는 건 딱:

* 레포지토리 폴더 (코드 + `.git`)
* 전역 설정 파일(`~/.gitconfig`)